<?php
error_reporting(0);
set_time_limit(0);

include 'db.php'; // اتصال به دیتابیس

$auth = $_POST['auth'];
if (empty($auth)) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$username = $_POST['username'];
if (empty($username)) {
    $response = ['status' => 'error', 'message' => 'empty username'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// فقط حروف انگلیسی، اعداد و زیرخط مجاز است
if (!preg_match('/^[a-zA-Z0-9_]+$/', $username)) {
    $response = ['status' => 'error', 'message' => 'فقط حروف انگلیسی، اعداد و _ مجاز است'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// طول نام کاربری بین ۳ تا ۱۶ کاراکتر
if (strlen($username) < 3 || strlen($username) > 16) {
    $response = ['status' => 'error', 'message' => 'نام کاربری باید بین ۲ تا ۱۶ کاراکتر باشد'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// نباید با عدد یا _ شروع شود
if (preg_match('/^[0-9_]/', $username)) {
    $response = ['status' => 'error', 'message' => 'نام کاربری نباید با عدد یا _ شروع شود'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// نباید با _ پایان یابد
if (substr($username, -1) === '_') {
    $response = ['status' => 'error', 'message' => 'نام کاربری نباید با _ پایان یابد'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// بررسی تکراری بودن یوزرنیم
$stmtCheckUsername = $pdo->prepare("SELECT COUNT(*) FROM users WHERE LOWER(username) = LOWER(:username)");
$stmtCheckUsername->execute(['username' => $username]);
$usernameExists = $stmtCheckUsername->fetchColumn();

if ($usernameExists) {
    $response = ['status' => 'error', 'message' => 'username already exists'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// یافتن کاربر بر اساس auth
$stmtUser = $pdo->prepare("
    SELECT u.*, d.auth, d.platform, d.device, d.date, d.ip
    FROM users u
    JOIN devices d ON u.id = d.user_id
    WHERE d.auth = :auth
");
$stmtUser->execute(['auth' => $auth]);
$userDevice = $stmtUser->fetch(PDO::FETCH_ASSOC);

if (!$userDevice) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if ($userDevice['ban']==='1') {
    $response = ['status' => 'error', 'message' => 'baned account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// بروزرسانی نام کاربری
$stmtUpdate = $pdo->prepare("UPDATE users SET username = :username, last_seen = :last_seen WHERE id = :user_id");
$stmtUpdate->execute([
    'username' => $username,
    'last_seen' => time(),
    'user_id' => $userDevice['id']
]);

$response = ['status' => 'success', 'message' => 'username updated'];
echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>