<?php
error_reporting(0);
set_time_limit(0);

include 'db.php'; // اتصال به دیتابیس

function encrypt($password, $message) {
    $ivBytes = hex2bin('00000000000000000000000000000000');
    $key = hash('sha256', $password, true);
    $cipherText = openssl_encrypt($message, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $ivBytes);
    $base64CipherText = base64_encode($cipherText);
    return $base64CipherText;
}

$auth = $_POST['auth'];
if (empty($auth)) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$stmt = $pdo->prepare("
    SELECT u.*, d.auth, d.platform, d.device, d.date, d.ip
    FROM users u
    JOIN devices d ON u.id = d.user_id
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$userDevice = $stmt->fetch(PDO::FETCH_ASSOC);

if ($userDevice) {
    if ($userDevice['ban']==='1') {
        $response = ['status' => 'error', 'message' => 'baned account'];
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit();
    } else {
        // دریافت پروفایل از جدول users
        $profile = !empty($userDevice['profile']) ? $userDevice['profile'] : "null";
        $username = !empty($userDevice['username']) ? $userDevice['username'] : "null";

        $newUserData = [
    'profile' => $profile,
    'number' => $userDevice['number'],
    'color' => $userDevice['color'],
    'blue_tick' => $userDevice['blue_tick'] == 1 ? "1" : "0",
    'developer' => $userDevice['developer'] == 1 ? "1" : "0",
    'bio' => $userDevice['bio'],
    'name' => $userDevice['name'],
    'username' => $username
];

        $data = json_encode($newUserData, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        $encrypted_text = encrypt($auth, $data);
        $response = ['status' => 'ok', 'message' => 'success', 'data' => $encrypted_text];
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit();
    }
} else {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}
?>