<?php
error_reporting(0);
set_time_limit(0);
include 'db.php';
include 'db2.php';

function encrypt($password, $message) {
    $ivBytes = hex2bin('00000000000000000000000000000000');
    $key = hash('sha256', $password, true);
    $cipherText = openssl_encrypt($message, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $ivBytes);
    return base64_encode($cipherText);
}

$auth = $_POST['auth'];

if (empty($auth)) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// دریافت اطلاعات کاربر با استفاده از auth
$stmt = $pdo->prepare("
    SELECT u.guid, u.name, u.id, u.ban
    FROM users u
    JOIN devices d ON d.user_id = u.id
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}
if ($user['ban'] === '1') {
    $response = ['status' => 'error', 'message' => 'baned account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}


$guid = $user['guid'];
$userId = $user['id'];

$chatTables = $pdo2->query("SHOW TABLES LIKE 'chat_{$userId}_%'")->fetchAll(PDO::FETCH_COLUMN);
$messages = [];
$appData = json_decode(file_get_contents('data/data.json'), true);
$pinnedAdData = $appData['pinnedAd'] === "true" && isset($appData['pinnedAdData']) ? $appData['pinnedAdData'] : [];

// اضافه کردن چت‌ها به خروجی
foreach ($chatTables as $table) {
        // استخراج id کاربر دوم از نام جدول
    preg_match("/chat_{$userId}_(\d+)/", $table, $matches);
    $secondUserId = $matches[1];

    // دریافت اطلاعات کاربر دوم
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
    $stmt->execute(['id' => $secondUserId]);
    $secondUser = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($secondUser) {
        $stmt = $pdo2->prepare("
        SELECT * 
        FROM $table 
        WHERE timestamp = (SELECT MAX(timestamp) FROM $table)
        LIMIT 1
        ");
        $stmt->execute();
        $lastMessage = $stmt->fetch(PDO::FETCH_ASSOC);
        $filename = $secondUser['guid'];
        $lastText = $lastMessage ? $lastMessage['text'] : "تاریخچه پاک شده است";
        $seen = $lastMessage['seen'];
        if ($seen === 'true') {
            $seen = "true";
        } else {
            $seen = "false";
        }
        

        $lastTextFor = (isset($lastMessage['user_id']) && intval($lastMessage['user_id']) === 1) ? "true" : "false";

        $lastSeen = $secondUser['last_seen'];
        $online = (time() - $lastSeen <= 10) ? "true" : "false";
        
        $oppositeTable = "chat_{$secondUserId}_{$userId}";
        $stmt = $pdo2->prepare("SELECT COUNT(*) FROM $oppositeTable WHERE seen = 'false'");
        $stmt->execute();
        $unreads = $stmt->fetchColumn();

        $messageObject = [
            'type' => 'chat',
            'ad' => "false",
            'guid' => $secondUser['guid'],
            'profile' => $secondUser['profile'] ?: "null",
            'last_message' => "$lastText",
            'for_you' => $lastTextFor,
            'online' => $online,
            'date' => "{$lastMessage['time']}",
            'unreads' => "$unreads",
            'name' => $secondUser['name'],
            'color' => "{$secondUser['color']}",
            'developer' => $secondUser['developer'] == 1 ? "true" : "false",
            'blue_tick' => $secondUser['blue_tick'] == 1 ? "true" : "false",
            'bio' => $secondUser['bio'],
            'ban' => $secondUser['ban'] == 1 ? "true" : "false",
            'username' => $secondUser['username'] ?: "null",
            'mute' => "false",
            'seen' => $seen,
            'timestamp' => $lastMessage['timestamp'],
        ];

        $messages[] = $messageObject;
    }
}

usort($messages, function ($a, $b) {
    return $b['timestamp'] - $a['timestamp'];
});

if (!empty($pinnedAdData)) {
    array_unshift($messages, $pinnedAdData);
}
$stmt = $pdo->prepare("UPDATE users SET last_seen = :time WHERE id = :id");
$stmt->execute(['time' => time(), 'id' => $userId]);

$finishArray = json_encode($messages, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
$encrypted_text = encrypt($auth, $finishArray);

$response = ['status' => 'ok', 'message' => 'success', 'data' => $encrypted_text];
echo $tt;
echo json_encode($response, JSON_UNESCAPED_UNICODE);

?>