<?php
error_reporting(0);
set_time_limit(0);

// اتصال به دیتابیس
include 'db.php';

$auth = $_POST['auth'];
$searchTerm = $_POST['search'];

if (empty($auth)) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if (empty($searchTerm) || strlen($searchTerm) < 3) {
    echo json_encode([], JSON_UNESCAPED_UNICODE);
    exit();
}

// مرحله 1: بررسی معتبر بودن auth
$stmtUser = $pdo->prepare("
    SELECT u.id, u.ban
    FROM users u
    JOIN devices d ON u.id = d.user_id
    WHERE d.auth = :auth
");
$stmtUser->execute(['auth' => $auth]);
$user = $stmtUser->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if ($user['ban'] === "1") {
    $response = ['status' => 'error', 'message' => 'baned account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// مرحله 2: جستجو در پایگاه داده و دریافت پروفایل
$stmtSearch = $pdo->prepare("
    SELECT u.username, u.name, u.blue_tick, u.developer, u.guid, u.color, u.bio, 
           u.profile, 
           CASE WHEN (UNIX_TIMESTAMP() - u.last_seen <= 7) THEN 'true' ELSE 'false' END AS online
    FROM users u
    WHERE u.username LIKE :searchTerm
    GROUP BY u.id
");
$stmtSearch->execute(['searchTerm' => "%$searchTerm%"]);
$results = $stmtSearch->fetchAll(PDO::FETCH_ASSOC);

$searchResults = [];
foreach ($results as $result) {
    $searchResults[] = [
        'online' => $result['online'] ?? 'null',
        'username' => $result['username'] ?? 'null',
        'name' => $result['name'] ?? 'null',
        'blue_tick' => $result['blue_tick'] ?? 'null',
        'developer' => $result['developer'] ?? 'null',
        'guid' => $result['guid'] ?? 'null',
        'color' => $result['color'] ?? 'null',
        'bio' => $result['bio'] ?? 'null',
        'profile' => $result['profile'] ?? 'null' // دریافت کلید profile از جدول users
    ];
}

echo json_encode($searchResults, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>